<?php
/* --------------------------------------------------------------
 TaxCalculationMode.php 2020-01-17
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 17 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Core\Configuration\Types;

use Gambio\Core\Configuration\Models\Read\Collections\Options;
use Gambio\Core\Configuration\Repositories\Components\OptionsResolver;

/**
 * Class TaxCalculationMode
 * @package Gambio\Core\Configuration\Types
 */
class TaxCalculationMode implements ConfigurationType
{
    /**
     * @inheritDoc
     */
    public function toOptions(OptionsResolver $resolver, string $value = null): ?Options
    {
        $data = [
            [
                'value' => 'None',
                'text'  => 'None',
            ],
            [
                'value' => 'Standard',
                'text'  => 'Standard',
            ],
            [
                'value' => 'Credit Note',
                'text'  => 'Credit Note',
            ],
        ];
        
        return Options::fromArray($data);
    }
    
    
    /**
     * @inheritDoc
     */
    public function inputType(): string
    {
        return 'dropdown';
    }
}